/*!
 * gulpfile.js
 *
 */

const gulp = require("gulp");
const del = require("del");
const less = require("gulp-less");
const rename = require("gulp-rename");
const concat = require('gulp-concat');
const minify   = require('gulp-minify')
const babel = require('gulp-babel')
const cleanCSS = require("gulp-clean-css");

// -----------------------------------------------------------------------------
// Path constant variables
// -----------------------------------------------------------------------------

const styleSrcDirectory = 'src/styles';
const styleBuildDirectory = 'css';
const javascriptSrcDirectory = 'src/js';
const javascriptBuildDirectory = 'js';

// -----------------------------------------------------------------------------
// Clean Functions
// -----------------------------------------------------------------------------

function cleanCss() {
    return del([styleBuildDirectory]);
}

function cleanJs() {
    return del([javascriptBuildDirectory]);
}

// -----------------------------------------------------------------------------
// CSS Build Functions
// -----------------------------------------------------------------------------

// compile main (min) css
function compileMainMinCss() {
    return gulp.src(styleSrcDirectory + '/main/default.less')
    .pipe(less())
    .pipe(cleanCSS({level: 1}))
    .pipe(rename({basename: 'main.min'}))
    .pipe(gulp.dest(styleBuildDirectory));
}

// compile main (min) css
function compileMainCss() {
    return gulp.src(styleSrcDirectory + '/main/default.less')
    .pipe(less())
    // .pipe(cleanCSS({level: 1}))
    .pipe(rename({basename: 'main'}))
    .pipe(gulp.dest(styleBuildDirectory));
}

// compile vendor css
function copyVendorCss() {
    return gulp.src([styleSrcDirectory + '/vendor/*.css'])
    .pipe(gulp.dest(styleBuildDirectory))
}

// -----------------------------------------------------------------------------
// JavaScript Build Functions
// -----------------------------------------------------------------------------

// main min JS
function buildMainMinJavascript() {
    return gulp.src([
        javascriptSrcDirectory + '/main/**/**.js'
    ])
    .pipe(babel({
        presets: ['@babel/env']
    }))
    .pipe(concat('main.js'))
    .pipe(minify({ ext: { min: '.min.js' }, noSource: true, preserveComments: 'some'}))
    .pipe(gulp.dest(javascriptBuildDirectory))
}

// main JS
function buildMainJavascript() {
    return gulp.src([
        javascriptSrcDirectory + '/main/**/**.js'
    ])
    .pipe(concat('main.js'))
    .pipe(gulp.dest(javascriptBuildDirectory))
}

// vendor JS
function copyVendorJs() {
    return gulp.src([javascriptSrcDirectory + '/vendor/**/**.js'])
    .pipe(gulp.dest(javascriptBuildDirectory))
}

// -----------------------------------------------------------------------------
// Gulp Functions
// -----------------------------------------------------------------------------

// Build CSS
const buildCSS = gulp.series(
    cleanCss,
    gulp.parallel(
        compileMainMinCss,
        compileMainCss,
        copyVendorCss
    )
);

// Build JavaScript
const buildJS = gulp.series(
    cleanJs,
    gulp.parallel(
        buildMainMinJavascript,
        buildMainJavascript,
        copyVendorJs
    )
);

// Build All
const buildAll = gulp.parallel(buildCSS, buildJS);

// watch functions
const watchCSS = () => {
    gulp.watch([styleSrcDirectory + '/**/**'], buildCSS);
};
const watchJS = () => {
    gulp.watch([javascriptSrcDirectory + '/**/**'], buildJS);
};
const watchAll = () => {
    gulp.watch([
        javascriptSrcDirectory + '/**/**',
        styleSrcDirectory + '/**/**'
        ], buildAll);
};

// --------------------------------------------------------

module.exports = {
    'default': buildAll,
    'build:css': buildCSS,
    'build:js': buildJS,
    'watch': watchAll,
    'watch:css': watchCSS,
    'watch:js': watchJS
};

// EOF
